/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.asm.LoadingPlugin;
import cofh.core.command.CommandClearBlock;
import cofh.core.command.CommandCountBlock;
import cofh.core.command.CommandEnchant;
import cofh.core.command.CommandFixMojangsShit;
import cofh.core.command.CommandHand;
import cofh.core.command.CommandHelp;
import cofh.core.command.CommandKillAll;
import cofh.core.command.CommandReloadWorldgen;
import cofh.core.command.CommandReplaceBlock;
import cofh.core.command.CommandSyntax;
import cofh.core.command.CommandTPS;
import cofh.core.command.CommandTPX;
import cofh.core.command.CommandUnloadChunk;
import cofh.core.command.CommandVersion;
import cofh.core.command.ISubCommand;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CommandHandler
extends CommandBase {
    public static final String COMMAND_DISALLOWED = "\u00a7cYou are not allowed to use this command.";
    public static CommandHandler instance = new CommandHandler();
    private static TMap<String, ISubCommand> commands = new THashMap();
    private static DummyCommand dummy;

    public static void initCommands(FMLServerStartingEvent fMLServerStartingEvent) {
        fMLServerStartingEvent.registerServerCommand((ICommand)instance);
    }

    public static boolean registerSubCommand(ISubCommand iSubCommand) {
        if (!commands.containsKey((Object)iSubCommand.getCommandName())) {
            commands.put((Object)iSubCommand.getCommandName(), (Object)iSubCommand);
            return true;
        }
        return false;
    }

    public static Set<String> getCommandList() {
        return commands.keySet();
    }

    public static int getCommandPermission(String string) {
        return CommandHandler.getCommandExists(string) ? ((ISubCommand)commands.get((Object)string)).getPermissionLevel() : Integer.MAX_VALUE;
    }

    public static boolean getCommandExists(String string) {
        return commands.containsKey((Object)string);
    }

    public static boolean canUseCommand(ICommandSender iCommandSender, int n, String string) {
        if (CommandHandler.getCommandExists(string)) {
            return iCommandSender.canCommandSenderUseCommand(n, "cofh " + string) || iCommandSender instanceof EntityPlayerMP && n <= 0;
        }
        return false;
    }

    public int getRequiredPermissionLevel() {
        return -1;
    }

    public static void logAdminCommand(ICommandSender iCommandSender, ISubCommand iSubCommand, String string, Object ... objectArray) {
        dummy.setFromCommand(iSubCommand);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            float f;
            Number number;
            int n2;
            Object object = objectArray[i];
            if (!(object instanceof Number) || (float)(n2 = (number = (Number)object).intValue()) == (f = number.floatValue())) continue;
            objectArray[i] = String.format("%.2f", Float.valueOf(f));
        }
        CommandBase.func_152373_a((ICommandSender)iCommandSender, (ICommand)dummy, (String)string, (Object[])objectArray);
    }

    public String getCommandName() {
        return "cofh";
    }

    public List getCommandAliases() {
        return null;
    }

    public String getCommandUsage(ICommandSender iCommandSender) {
        return "/" + this.getCommandName() + " help";
    }

    public boolean canCommandSenderUseCommand(ICommandSender iCommandSender) {
        return true;
    }

    public void processCommand(ICommandSender iCommandSender, String[] stringArray) {
        ISubCommand iSubCommand;
        if (stringArray.length < 1) {
            stringArray = new String[]{"help"};
        }
        if ((iSubCommand = (ISubCommand)commands.get((Object)stringArray[0])) != null) {
            if (CommandHandler.canUseCommand(iCommandSender, iSubCommand.getPermissionLevel(), iSubCommand.getCommandName())) {
                iSubCommand.handleCommand(iCommandSender, stringArray);
                return;
            }
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        throw new CommandNotFoundException("info.cofh.command.notFound", new Object[0]);
    }

    public List addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            return CommandHandler.getListOfStringsFromIterableMatchingLastWord((String[])stringArray, (Iterable)commands.keySet());
        }
        if (commands.containsKey((Object)stringArray[0])) {
            return ((ISubCommand)commands.get((Object)stringArray[0])).addTabCompletionOptions(iCommandSender, stringArray);
        }
        return null;
    }

    static {
        CommandHandler.registerSubCommand(CommandHelp.instance);
        CommandHandler.registerSubCommand(CommandSyntax.instance);
        CommandHandler.registerSubCommand(CommandVersion.instance);
        CommandHandler.registerSubCommand(CommandKillAll.instance);
        CommandHandler.registerSubCommand(CommandTPS.instance);
        CommandHandler.registerSubCommand(CommandTPX.instance);
        CommandHandler.registerSubCommand(CommandEnchant.instance);
        CommandHandler.registerSubCommand(CommandClearBlock.instance);
        CommandHandler.registerSubCommand(CommandReplaceBlock.instance);
        CommandHandler.registerSubCommand(CommandUnloadChunk.instance);
        CommandHandler.registerSubCommand(CommandReloadWorldgen.instance);
        CommandHandler.registerSubCommand(CommandCountBlock.instance);
        CommandHandler.registerSubCommand(CommandHand.instance);
        if (!LoadingPlugin.obfuscated) {
            CommandHandler.registerSubCommand(CommandFixMojangsShit.instance);
        }
        dummy = new DummyCommand();
    }

    private static class DummyCommand
    extends CommandBase {
        private int perm = 4;
        private String name = "";

        private DummyCommand() {
        }

        public void setFromCommand(ISubCommand iSubCommand) {
            this.name = iSubCommand.getCommandName();
            this.perm = iSubCommand.getPermissionLevel();
        }

        public String getCommandName() {
            return "cofh " + this.name;
        }

        public int getRequiredPermissionLevel() {
            return this.perm;
        }

        public String getCommandUsage(ICommandSender iCommandSender) {
            return "";
        }

        public void processCommand(ICommandSender iCommandSender, String[] stringArray) {
        }
    }
}

